// priority: 9

// 创建一个集合用于保存需要保护的末影水晶实体
/** @type {Set.<Internal.EndCrystal_>} */
let 受保护水晶 = new Set()
// 创建一个集合用于凋零受伤冷却
let 冷却集合 = new Set();

ItemEvents.entityInteracted(e => {
  let { item: 物品, target: 实体, server: s, level: 世界 } = e;
  let 横坐标 = 实体.x;
  let 纵坐标 = 实体.y;
  let 竖坐标 = 实体.z;

  // 当使用“深渊之心”右键“无名术士”时
  if (物品.id !== "enigmaticlegacy:abyssal_heart") return;
  if (实体.type !== "cataclysm:nameless_sorcerer") return;
  物品.count--;
  // 外层循环：决定了要“计划”多少次闪电的生成。
  // 这里循环30次，意味着将会有30个“批次”的闪电被安排。
  for (let 循环一 = 0; 循环一 < 30; 循环一++) {

    // scheduleInTicks 是一个定时器函数，它会在指定的“游戏刻(tick)”之后执行一段代码。
    // 在Minecraft中，1秒 = 20个游戏刻。
    // 第一个参数 i * 5 是延迟时间。
    s.scheduleInTicks(循环一 * 5, () => {

      // 内层循环：决定了在每一个计划好的时间点，要生成多少道闪电。
      // 这里循环5次，意味着每一“批次”都包含5道闪电。
      for (let 循环二 = 0; 循环二 < 5; 循环二++) {

        // 创建一个实体，类型是 "minecraft:lightning_bolt" (闪电)。
        let 闪电 = 世界.createEntity("minecraft:lightning_bolt");

        // 这是一个好的编程习惯，确保实体成功创建了。
        if (闪电) {
          // 设置这道闪电的位置为预先定义的 X, Y, Z 坐标。
          闪电.setPos(横坐标, 纵坐标, 竖坐标);
          // 在世界中生成（召唤）这道闪电，让它可见并产生效果。
          闪电.spawn();
        }
      }
    });
  }
  // 在闪电特效结束后，转换实体
  s.scheduleInTicks(140, () => {
    if (!实体.isAlive()) return;
    实体.discard();
    let 使徒 = 世界.createEntity("goety:apostle");
    if (使徒) {
      使徒.mergeNbt({
        CustomName: "{'text':'终焉引渡者·七渊使徒-星野爱桃'}",
        CustomNameVisible: 1,
        titleNumber: 0,
        // titleNumber 编号用于区分不同等级或能力的使徒，并赋予不同的效果。
        // 0: The Risen - 不灭重生 - 使徒的回血速率翻倍。
        // 1: The Abhorrent - 憎恶本质 - 箭矢是瞬间伤害效果。（如果使徒的对手是亡灵生物，则箭矢的效果会变成瞬间治疗）
        // 2: The Defiler - 毒蝎之尾 - 箭矢给予中毒效果。
        // 3: The Dark - 漆黑暗影 - 箭矢给予凋零效果。
        // 4: The Great Shadow - 黑天使之影 - 箭矢给予失明效果(in Goety 1)/黑暗效果，尽管二阶段也会变成失明(in Goety 2)。
        // 5: The Witch King - 女巫之王 - 箭矢给予虚弱效果。
        // 6: The Pyre Lord - 爆燃领主 - 箭矢会点燃目标五秒并且给予灼烧魔印效果。
        // 7: The Profane - 天启饥荒 - 箭矢给予饥饿效果。
        // 8: The Cruel - 冷酷寒冬 - 箭矢给予缓慢效果。
        // 9: The Terrible - 骇人之物 - 使徒会拥有无限时长的速度II效果。
        // 10: The Glorious - 荣耀之名 - 使徒会拥有无限时长的抗性提升效果。
        // 11: The Atrocious - 十恶不赦 - 箭矢给予侵蚀效果
        coolDown: 100,
        regen: 1,
        ForgeCaps: {
          "goety:witchbarter": { barterTimer: 0, barterTraderID: -1 },
        }
      });
      使徒.setPos(横坐标, 纵坐标, 竖坐标);
      使徒.spawn();
    }
  });
});

NativeEvents.onEvent(Java.loadClass("net.minecraftforge.event.entity.EntityJoinLevelEvent"), e => {
    let { entity: 实体 } = e
    // 仅在服务器端处理
    if (!实体.level.isClientSide()) {
        // 如果实体是末影水晶并且 NBT 数据中包含 ShowBottom = true，则加入保护集合
        if (实体 instanceof $末影水晶) {
            let 水晶 = 实体
            if (水晶.nbt.getBoolean("ShowBottom")) {
                受保护水晶.add(水晶)
            }
        }
        // 如果实体是末影龙，等待 100 tick 后，将保护集合内的末影水晶设置为无敌
        if (实体 instanceof $末影龙) {
            实体.server.scheduleInTicks(100, () => {
                受保护水晶.forEach(水晶 => 水晶.mergeNbt({ Invulnerable: true }))
                受保护水晶.clear() // 清空集合
            })
        }
    }
});

NativeEvents.onEvent(Java.loadClass("net.minecraftforge.event.entity.player.AttackEntityEvent"), e => {
    let { entity: 攻击者, target: 目标实体 } = e
    // 仅在服务器端处理
    if (!攻击者.level.isClientSide()) {
        // 如果攻击者是p且目标是末影水晶
        if (攻击者 instanceof $玩家 && 目标实体 instanceof $末影水晶) {
            let p = 攻击者
            let 被攻击水晶 = 目标实体
            let 攻击范围 = 3 // 默认攻击范围
            // 如果玩家有额外的攻击距离属性（如 forge 的扩展），则获取其值
            if (p.attributes.hasAttribute("forge:entity_reach")) {
                攻击范围 = p.getAttributeValue("forge:entity_reach")
            }
            // 判断玩家是否在攻击范围内，若是则解除水晶无敌并造成伤害
            if (p.distanceToEntity(被攻击水晶) <= 攻击范围) {
                被攻击水晶.mergeNbt({ Invulnerable: false })
                被攻击水晶.attack(20) // 对水晶造成伤害
            }
        }
    }
});
// 阻止在特殊地点使用凋零骷髅头召唤凋零
BlockEvents.rightClicked(e => {
    let { block: 方块, item: 物品, player: p, level: 世界 } = e;
    let { x: 横坐标, y: 纵坐标, z: 竖坐标 } = 方块;

    // 非凋零骷髅头直接退出
    if (!物品.id.equals("minecraft:wither_skeleton_skull")) return;
    // 仅对灵魂沙或灵魂土有效
    if (!方块.id.equals("minecraft:soul_sand") &&
        !方块.id.equals("minecraft:soul_soil")) return;
        
    // 在末地特殊区域内阻止召唤凋零
    if (p.level.dimension == "minecraft:the_end") {
        // 龙岛中心区域
        if (横坐标 >= -3 && 横坐标 <= 3 && 竖坐标 >= -3 && 竖坐标 <= 3) {
            p.setStatusMessage(`不准在龙巢底下召唤凋零，你的凋零骷髅头我没收了！！！`);
            // 召唤闪电警告
            let 闪电 = 世界.createEntity("minecraft:lightning_bolt");
            if (闪电) {
                闪电.setPos(p.x, p.y, p.z);
                闪电.spawn();
            }
            e.cancel(); // 阻止事件
        }
        // 末地折跃门区域
        if (纵坐标 >= 70 && 纵坐标 <= 80) {
            p.setStatusMessage(`不准在折跃门旁边召唤凋零，你的凋零骷髅头我没收了！！！`);
            let 闪电 = 世界.createEntity("minecraft:lightning_bolt");
            if (闪电) {
                闪电.setPos(p.x, p.y, p.z);
                闪电.spawn();
            }
            e.cancel();
        }
    }
    // 阻止在地狱顶部召唤凋零
    if (p.level.dimension == "minecraft:the_nether") {
        if (纵坐标 >= 185 && 纵坐标 <= 191) {
            p.setStatusMessage(`地狱顶部严令禁止召唤凋零，没收！！！`);
            let 闪电 = 世界.createEntity("minecraft:lightning_bolt");
            if (闪电) {
                闪电.setPos(p.x, p.y, p.z);
                闪电.spawn();
            }
            e.cancel();
        }
    }
});

EntityEvents.spawned(e => {
    let { entity: 实体, level: 世界, server: s } = e;
    let 实体类型 = 实体.type;
    // 当生成隐形盔甲架时，替换为无名术士
    if (实体类型 === "minecraft:armor_stand") {
        let 实体NBT = 实体.nbt;
        if (实体NBT && 实体NBT.Invisible === 1) {
          let 召唤 = false;
          if (实体NBT.CustomName && typeof 实体NBT.CustomName === "string") {
            if (实体NBT.CustomName.includes("Join our Discord server to")) {
              召唤 = true;
            }
          } else if (实体NBT.CustomName && typeof 实体NBT.CustomName.asString === "function") {
            if (实体NBT.CustomName.asString().includes("Join our Discord server to")) {
              召唤 = true;
            }
          }
          if (召唤) {
            let 无名术士 = 世界.createEntity("cataclysm:nameless_sorcerer");
            if (无名术士) {
              无名术士.setPos(实体.x, 实体.y, 实体.z);
              无名术士.spawn();
            }
          }
          e.cancel();
        }
    }
    // 为新生成的无名术士添加特殊NBT
    if (实体类型 === "cataclysm:nameless_sorcerer") {
        // 为无名术士添加NBT标签
        实体.mergeNbt({
          Invulnerable: 1, // 无敌
          NoAI: 1,         // 无AI
          Silent: 1,       // 静音
          PersistenceRequired: 1 // 永久存在，不会被游戏自然移除
        });
    }
    // 当凋零骷髅火球生成时，有小概率召唤凋零骷髅
    if (实体类型 == "entity.minecraft.wither_skull") {
        let 概率 = Math.floor(Math.random() * 6); // 1/6 概率
        if (概率 == 0) {
            let 骷髅 = 世界.createEntity("minecraft:wither_skeleton");
            if (骷髅) {
                骷髅.setPos(实体.x + 概率, 实体.y + 1, 实体.z + 概率);
                骷髅.spawn();
            }
        }
    }
    // 如果生成的是末影龙火球，触发连续闪电生成
    if (实体类型 == "entity.minecraft.dragon_fireball") {
        let 生成次数 = 50         // 总共生成 50 次
        let 每次数量 = 5          // 每次生成 5 道闪电
        let 生成间隔 = 5       // 每次间隔 5 tick
        for (let 循环一 = 0; 循环一 < 生成次数; 循环一++) {
            s.scheduleInTicks(循环一 * 生成间隔, () => {
                for (let 循环二 = 0; 循环二 < 每次数量; 循环二++) {
                    let X = Math.floor(Math.random() * 71) - 35
                    let Y = Math.floor(Math.random() * 16) + 50
                    let Z = Math.floor(Math.random() * 71) - 35
                    let 闪电 = 世界.createEntity("minecraft:lightning_bolt")
                    if (闪电) {
                        闪电.setPos(X, Y, Z)
                        闪电.spawn()
                    }
                }
            })
        }
    }
    // 如果生成的是 EnderTrigon 模组的火焰攻击，生成潜影贝子弹
    if (实体类型 == "entity.endertrigon.dragon_flame") {
        let 生成次数二 = 2          // 生成 2 次
        let 每次数量二 = 1          // 每次 1 个
        let 生成间隔二 = 5       // 每 5 tick 一次
        for (let 循环一一 = 0; 循环一一 < 生成次数二; 循环一一++) {
            s.scheduleInTicks(循环一一 * 生成间隔二, () => {
                for (let 循环二二 = 0; 循环二二 < 每次数量二; 循环二二++) {
                    let 生成横坐标二 = Math.floor(Math.random() * 71) - 35
                    let Y二 = Math.floor(Math.random() * 16) + 50
                    let Z二 = Math.floor(Math.random() * 71) - 35
                    let 子弹 = 世界.createEntity("minecraft:shulker_bullet")
                    if (子弹) {
                        子弹.setPos(生成横坐标二, Y二, Z二)
                        子弹.spawn()
                    }
                }
            })
        }
    }
});

EntityEvents.death(e => {
    let { entity: 实体, level: 世界 } = e;
    let 实体类型 = 实体.type;

    // 暮色恶魂死亡时生成巫妖
    if (实体类型 === "twilightforest:ur_ghast") {
        let 暗夜巫妖 = 世界.createEntity("bosses_of_mass_destruction:lich");
        if (暗夜巫妖) {
            暗夜巫妖.setPos(实体.x, 实体.y, 实体.z);
            暗夜巫妖.spawn();
        }
    }

    // 末影人死亡事件：有小概率在中心区域召唤末影水晶
    if (实体类型 == "entity.minecraft.enderman") {
        let { x: 横坐标, y: 纵坐标, z: 竖坐标 } = 实体;
        let 概率计数 = Math.floor(Math.random() * 10) + 1 // 1~10 随机数
        if (横坐标 > -100 && 横坐标 < 100 &&
            纵坐标 > 0 && 纵坐标 < 100 &&
            竖坐标 > -100 && 竖坐标 < 100 &&
            概率计数 == 10) { // 满足条件且随机数命中
            let 末影水晶 = 世界.createEntity("minecraft:end_crystal")
            if (末影水晶) {
                let X = Math.floor(Math.random() * 51) - 25
                let Y = Math.floor(Math.random() * 31) + 70
                let Z = Math.floor(Math.random() * 51) - 25
                末影水晶.setPos(X, Y, Z)
                末影水晶.spawn()
            }
        }
    }
});
// 为末影龙添加行为目标
EntityJSEvents.addGoalSelectors("minecraft:ender_dragon", e => {
    // 添加行为目标（数字越小优先级越高）
    e.panic(6, 0.5)                                       // 受伤逃跑
    e.floatSwim(2)                                        // 漂浮
    e.meleeAttack(3, 1.8, false)                          // 近战攻击
    e.leapAtTarget(4, 0.4)                                // 跳跃扑击
    e.waterAvoidingRandomStroll(5, 0.4, 0.1)              // 回避水的闲逛
    e.lookAtEntity(1, $玩家, 200, 0.9, false)             // 注视p
    e.randomLookAround(7)                                 // 随机环顾四周
    // 添加自定义追踪目标逻辑
    e.customGoal("follow_target", 1, 生物 => true, 生物 => true, true, 生物 => { }, 生物 => 生物.getNavigation().stop(), true,
        生物 => {                            // 每 tick 执行的行为
            let 生物包围盒 = 生物.boundingBox.inflate(100) // 范围扩大
            生物.level.getEntitiesWithin(生物包围盒).forEach(实体 => {
                if (实体 && 实体.$玩家 && 实体.distanceToEntity(生物) < 100) {
                    生物.getNavigation().moveTo(实体.block.x, 实体.y, 实体.z, 1.0)
                }
            })
        }
    );
    // 移除恐慌行为，防止与自定义目标冲突
    e.removeGoal($恐慌);
    // 使用条件方式移除行为目标
    e.removeGoals(上下文 => {
        let { goal: 目标, entity: 实体 } = 上下文
        return 目标.getClass() == $恐慌
    });
});
// 为凋零添加/修改 AI 行为目标
EntityJSEvents.addGoalSelectors("minecraft:wither", e => {
    // 行为目标添加（优先级越低越先执行）
    e.panic(6, 0.5); // 恐慌逃跑
    e.floatSwim(2);  // 漂浮
    e.meleeAttack(3, 1.8, false); // 近战攻击
    e.leapAtTarget(4, 0.4);       // 跳跃扑击
    e.waterAvoidingRandomStroll(5, 0.4, 0.1); // 回避水随机游走
    e.lookAtEntity(1, $玩家, 200, 0.9, false); // 注视p
    e.randomLookAround(7); // 随机看周围

    // 自定义追踪逻辑：扫描周围 100 格p并向其移动
    e.customGoal("follow_target", 1, 生物 => true, 生物 => true, true, 生物 => { }, 生物 => 生物.getNavigation().stop(), true,
        /** @param {Internal.Mob} 生物 */
        生物 => {
            let 生物包围盒 = 生物.boundingBox.inflate(100);
            生物.level.getEntitiesWithin(生物包围盒).forEach(实体 => {
                if (实体 && 实体.$玩家 && 实体.distanceToEntity(生物) < 100) {
                    生物.getNavigation().moveTo(实体.block.x, 实体.y, 实体.z, 1.0);
                }
            });
        }
    );
    // 移除默认的 Panic 行为（如果存在）
    e.removeGoal($恐慌);
    e.removeGoals(上下文 => {
        const { goal: 目标, entity: 实体 } = 上下文;
        return 目标.getClass() == $恐慌;
    });
});